unit Unit1;

//    FloodFill   fsBorder.
//      , 
//   ALT      .

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    LabelTitle: TLabel;
    Panel1: TPanel;
    Image1: TImage;
    BttClear: TButton;
    CBoxFloodStyle: TComboBox;
    STxtPen: TStaticText;
    ColorDialog1: TColorDialog;
    STxtBrush: TStaticText;
    CBoxTexture: TComboBox;
    Label2: TLabel;
    Label4: TLabel;
    procedure BttClearClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure STxtPenClick(Sender: TObject);
    procedure STxtBrushClick(Sender: TObject);
   
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

//   Image  
procedure ClearImage(RqImg : TImage; RqColor : TColor);
begin
  with RqImg do
  begin
    //   
    Canvas.Brush.Style := bsSolid;
    Canvas.Brush.Color := RqColor;
    //    Image1  
    Canvas.FillRect(Rect(0,0, Width, Height));
  end;
end;

//  
procedure TForm1.FormCreate(Sender: TObject);
begin
   ClearImage (Image1, Self.Canvas.Brush.Color);
   STxtPen.Color   := clBlue;
   STxtBrush.Color := clSkyBlue;
end;

//  Image
procedure TForm1.BttClearClick(Sender: TObject);
begin
   ClearImage (Image1, Self.Canvas.Brush.Color);
end;

//     
procedure TForm1.Image1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var  BM : TBitMap;
begin
  with Image1.Canvas do
  begin
    if Shift * [ssAlt] = []
    then begin
       //   
       MoveTo(X,Y);
       Pen.Width := 2;
       Pen.Color := STxtPen.Color;
    end
    else begin
       case  CBoxFloodStyle.ItemIndex of
       0 : begin
           Brush.Color := STxtBrush.Color;
           Brush.Style := bsSolid;
           FloodFill(X, Y, STxtPen.Color, fsBorder);
       end;
       1 : begin
           //  ,  
           BM  := TBitmap.Create;
           try
              case CBoxTexture.ItemIndex of
              0 : BM.LoadFromFile('.\Textures\Fler.bmp');
              1 : BM.LoadFromFile('.\Textures\BlueWawe.bmp');
              2 : BM.LoadFromFile('.\Textures\Basalt.bmp');
              3 : BM.LoadFromFile('.\Textures\Tree.bmp');
              4 : BM.LoadFromFile('.\Textures\Ball.bmp');
              end;
              Brush.Bitmap := BM;
              FloodFill(X, Y, STxtPen.Color, fsBorder);
           finally
              Brush.Bitmap := nil;
              BM.Free;
           end;
       end;
       end;
    end;
  end;
end;

//  
procedure TForm1.Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
   if Shift = [ssLeft] then Image1.Canvas.LineTo(X,Y);
end;

//   
procedure TForm1.STxtPenClick(Sender: TObject);
begin
  if ColorDialog1.Execute then STxtPen.Color := ColorDialog1.Color;
end;

//   
procedure TForm1.STxtBrushClick(Sender: TObject);
begin
  if ColorDialog1.Execute then STxtBrush.Color := ColorDialog1.Color;
end;

end.
